/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.sequences;

import jlibs.core.graph.sequences.AbstractSequence;

public class DuplicateSequence<E>
extends AbstractSequence<E> {
    private E elem;
    private int count;
    private int pos;

    public DuplicateSequence(E elem) {
        this(elem, 1);
    }

    public DuplicateSequence(E elem, int count) {
        if (elem == null) {
            throw new IllegalArgumentException("elem can't be null");
        }
        if (count < 0) {
            throw new IllegalArgumentException(String.format("can't duplicate %d times", count));
        }
        this.elem = elem;
        this.count = count;
        this._reset();
    }

    @Override
    protected E findNext() {
        ++this.pos;
        return this.pos <= this.count ? (E)this.elem : null;
    }

    @Override
    public void reset() {
        super.reset();
        this._reset();
    }

    private void _reset() {
        this.pos = 0;
    }

    @Override
    public DuplicateSequence<E> copy() {
        return new DuplicateSequence<E>(this.elem, this.count);
    }

    @Override
    public int length() {
        return this.count;
    }
}

