/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util;

import java.util.Arrays;

public abstract class Heap<E> {
    private Object[] queue;
    private int size = 0;

    public Heap(int initialCapacity) {
        this.queue = new Object[initialCapacity];
    }

    private void grow(int minCapacity) {
        int newCapacity;
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        int oldCapacity = this.queue.length;
        int n = newCapacity = oldCapacity < 64 ? (oldCapacity + 1) * 2 : oldCapacity / 2 * 3;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.queue = Arrays.copyOf(this.queue, newCapacity);
    }

    public int size() {
        return this.size;
    }

    public E root() {
        return (E)(this.size == 0 ? null : this.queue[0]);
    }

    public void add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int i = this.size;
        if (i >= this.queue.length) {
            this.grow(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
            this.setIndex(e, 0);
        } else {
            this.siftUp(i, e);
        }
    }

    private void siftUp(int k, E x) {
        int parent;
        Object e;
        while (k > 0 && this.compare(x, e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            this.setIndex(e, k);
            k = parent;
        }
        this.queue[k] = x;
        this.setIndex(x, k);
    }

    public E get(int i) {
        if (i >= this.size) {
            return null;
        }
        return (E)this.queue[i];
    }

    public E removeAt(int i) {
        int s;
        if (i >= this.size) {
            return null;
        }
        Object removed = this.queue[i];
        if ((s = --this.size) == i) {
            this.queue[i] = null;
        } else {
            Object moved = this.queue[s];
            this.queue[s] = null;
            this.siftDown(i, moved);
        }
        assert (this.queue[i] != removed);
        this.setIndex(removed, -1);
        return (E)removed;
    }

    private void siftDown(int k, E x) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            Object c = this.queue[child];
            int right = child + 1;
            if (right < this.size && this.compare(c, this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (this.compare(x, c) <= 0) break;
            this.queue[k] = c;
            this.setIndex(c, k);
            k = child;
        }
        this.queue[k] = x;
        this.setIndex(x, k);
    }

    protected abstract void setIndex(E var1, int var2);

    protected abstract int compare(E var1, E var2);
}

